<?php
session_start();

$admin_password = '123456*';

if (isset($_POST['logout'])) {
    session_destroy();
    unset($_SESSION['admin_logged_in']);
    header('Location: index.php');
    exit;
}

if (isset($_POST['password'])) {
    if ($_POST['password'] === $admin_password) {
        $_SESSION['admin_logged_in'] = true;
    } else {
        $error = 'Hatalı şifre!';
    }
}

if (!isset($_SESSION['admin_logged_in'])): ?>
    <!DOCTYPE html>
    <html lang="tr">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Admin Giriş</title>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css">
    </head>
<body class="bg-slate-950 flex items-center justify-center min-h-screen px-4">
    <form method="post" class="w-full max-w-sm bg-slate-900 border border-slate-800 rounded-2xl p-6 shadow-xl space-y-4">
        <div class="flex items-center gap-3">
            <div class="h-10 w-10 rounded-xl bg-gradient-to-br from-cyan-400 to-emerald-400 grid place-items-center text-slate-900 font-bold">AD</div>
            <div>
                <p class="text-xs text-slate-400">Yönetici Girişi</p>
                <h1 class="text-xl font-bold text-white">Panel</h1>
            </div>
        </div>
            <?php if (isset($error)): ?>
            <div class="text-sm text-red-400 bg-red-500/10 border border-red-500/30 rounded-lg px-3 py-2"><?= $error ?></div>
            <?php endif; ?>
        <input type="password" name="password" placeholder="Şifre" class="w-full rounded-xl bg-slate-800 border border-slate-700 px-4 py-3 text-white focus:outline-none focus:ring-2 focus:ring-cyan-400" />
        <button type="submit" class="w-full rounded-xl bg-gradient-to-r from-cyan-400 to-emerald-400 text-slate-900 font-bold py-3 shadow-lg">Giriş Yap</button>
        </form>
    </body>
    </html>
    <?php exit; endif; ?>

<?php
$dataFile = __DIR__ . '/data.json';
if (!file_exists($dataFile)) {
    file_put_contents($dataFile, json_encode([
        'meta' => ['title' => 'Başlık', 'description' => 'Açıklama'],
        'popup' => ['title' => 'Günün Sitesi', 'desc' => 'Güvenli ve hızlı kazanç için hemen katıl!', 'button_text' => 'HEMEN GİR', 'button_link' => '#'],
        'banner_titles' => [],
        'top_banners' => [],
        'bottom_banners' => [],
        'sites' => [],
        'contacts' => [],
        'ticker_top' => ['text' => 'En güncel kampanyalar', 'button_text' => 'Git', 'button_link' => '#'],
        'ticker_bottom' => ['text' => 'Güvenli yönlendirme', 'button_text' => 'Detay', 'button_link' => '#'],
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}
$data = json_decode(file_get_contents($dataFile), true);

// Varsayılanları doldur
$data['meta'] = $data['meta'] ?? ['title' => '', 'description' => ''];
$data['popup'] = $data['popup'] ?? ['title' => '', 'desc' => '', 'button_text' => '', 'button_link' => ''];
$data['banner_titles'] = $data['banner_titles'] ?? [];
$data['ticker_top'] = $data['ticker_top'] ?? ['text' => '', 'button_text' => '', 'button_link' => ''];
$data['ticker_bottom'] = $data['ticker_bottom'] ?? ['text' => '', 'button_text' => '', 'button_link' => ''];
$data['contacts'] = $data['contacts'] ?? [];
for ($i = 0; $i < 3; $i++) {
    $data['top_banners'][$i] = $data['top_banners'][$i] ?? ['image' => '', 'url' => '', 'alt' => 'Banner '.($i+1)];
    $data['bottom_banners'][$i] = $data['bottom_banners'][$i] ?? ['image' => '', 'url' => '', 'alt' => 'Banner '.($i+1)];
}
$data['sites'] = $data['sites'] ?? [];

$flash = null;

// Genel toplu kaydet
if (isset($_POST['general_save'])) {
    $data['meta']['title'] = trim($_POST['meta_title'] ?? '');
    $data['meta']['description'] = trim($_POST['meta_description'] ?? '');

    $data['popup']['title'] = trim($_POST['popup_title'] ?? '');
    $data['popup']['button_text'] = trim($_POST['popup_button_text'] ?? '');
    $data['popup']['desc'] = trim($_POST['popup_desc'] ?? '');
    $data['popup']['button_link'] = trim($_POST['popup_button_link'] ?? '');

    $data['ticker_top']['text'] = trim($_POST['ticker_top_text'] ?? '');
    $data['ticker_top']['button_text'] = trim($_POST['ticker_top_button_text'] ?? '');
    $data['ticker_top']['button_link'] = trim($_POST['ticker_top_button_link'] ?? '');

    $data['ticker_bottom']['text'] = trim($_POST['ticker_bottom_text'] ?? '');
    $data['ticker_bottom']['button_text'] = trim($_POST['ticker_bottom_button_text'] ?? '');
    $data['ticker_bottom']['button_link'] = trim($_POST['ticker_bottom_button_link'] ?? '');

    $titles = array_values(array_filter(array_map('trim', explode("\n", $_POST['banner_titles'] ?? ''))));
    $data['banner_titles'] = $titles;

    for ($i = 0; $i < 3; $i++) {
        $data['top_banners'][$i]['image'] = trim($_POST['top_banner_image'][$i] ?? '');
        $data['top_banners'][$i]['url'] = trim($_POST['top_banner_url'][$i] ?? '');
        $data['top_banners'][$i]['alt'] = trim($_POST['top_banner_alt'][$i] ?? 'Banner '.($i+1));

        $data['bottom_banners'][$i]['image'] = trim($_POST['bottom_banner_image'][$i] ?? '');
        $data['bottom_banners'][$i]['url'] = trim($_POST['bottom_banner_url'][$i] ?? '');
        $data['bottom_banners'][$i]['alt'] = trim($_POST['bottom_banner_alt'][$i] ?? 'Banner '.($i+1));
    }

    file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    $flash = 'Genel ayarlar kaydedildi.';
}

// Birleşik liste oluştur (site + contact)
$combined = [];
foreach ($data['sites'] as $s) { $s['type'] = 'site'; $combined[] = $s; }
foreach ($data['contacts'] as $c) { $c['type'] = 'contact'; $combined[] = $c; }

// Sıralama değiştir (birleşik)
if (isset($_POST['move_up_combined'])) {
    $idx = intval($_POST['move_up_combined']);
    if ($idx > 0) { [$combined[$idx-1], $combined[$idx]] = [$combined[$idx], $combined[$idx-1]]; }
}
if (isset($_POST['move_down_combined'])) {
    $idx = intval($_POST['move_down_combined']);
    if ($idx < count($combined)-1) { [$combined[$idx+1], $combined[$idx]] = [$combined[$idx], $combined[$idx+1]]; }
}

// Yeni içerik ekle (liste sonuna)
if (isset($_POST['item_add'])) {
    $typeNew = $_POST['item_type_new'] ?? 'site';
    $logoNew = trim($_POST['item_logo_link_new'] ?? '');
    if (!empty($_FILES['item_logo_upload_new']['name'])) {
        $target_dir = __DIR__ . '/uploads/';
        if (!is_dir($target_dir)) mkdir($target_dir, 0777, true);
        $filename = uniqid('logo_') . '_' . basename($_FILES['item_logo_upload_new']['name']);
        $target_file = $target_dir . $filename;
        if (move_uploaded_file($_FILES['item_logo_upload_new']['tmp_name'], $target_file)) {
            $logoNew = 'uploads/' . $filename;
        }
    }
    if ($typeNew === 'contact') {
        $combined[] = [
            'type' => 'contact',
            'name' => trim($_POST['item_name_new'] ?? ''),
            'text' => trim($_POST['item_text_new'] ?? ''),
            'url' => trim($_POST['item_url_new'] ?? ''),
            'button_text' => trim($_POST['item_button_text_new'] ?? 'GİT'),
            'logo' => $logoNew,
        ];
    } else {
        $combined[] = [
            'type' => 'site',
            'name' => trim($_POST['item_name_new'] ?? ''),
            'url' => trim($_POST['item_url_new'] ?? ''),
            'bonus' => trim($_POST['item_text_new'] ?? ''),
            'stars' => floatval($_POST['item_stars_new'] ?? 4),
            'button_text' => trim($_POST['item_button_text_new'] ?? 'GİRİŞ YAP'),
            'licensed_badge' => [
                'show' => isset($_POST['item_badge_show_new']),
                'text' => trim($_POST['item_badge_text_new'] ?? 'LİSANSLI')
            ],
            'logo' => $logoNew,
        ];
        }
    $data['sites'] = array_values(array_filter($combined, fn($x) => $x['type'] === 'site'));
    $data['contacts'] = array_values(array_filter($combined, fn($x) => $x['type'] === 'contact'));
    foreach ($data['sites'] as &$s) unset($s['type']);
    foreach ($data['contacts'] as &$c) unset($c['type']);
    file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    $flash = 'Yeni içerik eklendi.';
        }

// Birleşik kaydet
if (isset($_POST['combined_save']) && isset($_POST['item_name']) && is_array($_POST['item_name'])) {
    $combined = [];
    foreach ($_POST['item_name'] as $idx => $name) {
        $type = $_POST['item_type'][$idx] ?? 'site';
        $name = trim($name);
        $url  = trim($_POST['item_url'][$idx] ?? '');
        if ($name === '' && $url === '') continue;
        $logo = trim($_POST['item_logo_link'][$idx] ?? '');
        if (!empty($_FILES['item_logo_upload']['name'][$idx])) {
            $target_dir = __DIR__ . '/uploads/';
            if (!is_dir($target_dir)) mkdir($target_dir, 0777, true);
            $filename = uniqid('logo_') . '_' . basename($_FILES['item_logo_upload']['name'][$idx]);
            $target_file = $target_dir . $filename;
            if (move_uploaded_file($_FILES['item_logo_upload']['tmp_name'][$idx], $target_file)) {
                $logo = 'uploads/' . $filename;
            }
        }
        if ($type === 'contact') {
            $combined[] = [
                'type' => 'contact',
                'name' => $name,
                'text' => trim($_POST['item_text'][$idx] ?? ''),
                'url' => $url,
                'button_text' => trim($_POST['item_button_text'][$idx] ?? 'GİT'),
                'logo' => $logo,
            ];
        } else {
            $combined[] = [
                'type' => 'site',
                'name' => $name,
                'url' => $url,
                'bonus' => trim($_POST['item_text'][$idx] ?? ''),
                'stars' => floatval($_POST['item_stars'][$idx] ?? 4),
                'button_text' => trim($_POST['item_button_text'][$idx] ?? 'GİRİŞ YAP'),
                'licensed_badge' => [
                    'show' => isset($_POST['item_badge_show'][$idx]),
                    'text' => trim($_POST['item_badge_text'][$idx] ?? 'LİSANSLI')
                ],
                'logo' => $logo,
            ];
        }
    }
    // Ayır ve kaydet
    $data['sites'] = array_values(array_filter($combined, fn($x) => $x['type'] === 'site'));
    $data['contacts'] = array_values(array_filter($combined, fn($x) => $x['type'] === 'contact'));
    foreach ($data['sites'] as &$s) unset($s['type']);
    foreach ($data['contacts'] as &$c) unset($c['type']);
    file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    $flash = 'Liste kaydedildi.';
}

// Yeni site ekle
if (isset($_POST['site_add'])) {
    $item = [
        'name' => trim($_POST['site_name_new'] ?? ''),
        'url' => trim($_POST['site_url_new'] ?? ''),
        'bonus' => trim($_POST['site_bonus_new'] ?? ''),
        'stars' => floatval($_POST['site_stars_new'] ?? 4),
        'button_text' => trim($_POST['button_text_new'] ?? 'GİRİŞ YAP'),
        'licensed_badge' => [
            'show' => isset($_POST['licensed_badge_show_new']),
            'text' => trim($_POST['licensed_badge_text_new'] ?? 'LİSANSLI')
        ],
        'logo' => trim($_POST['site_logo_link_new'] ?? '')
    ];
    if (!empty($_FILES['site_logo_upload_new']['name'])) {
        $target_dir = __DIR__ . '/uploads/';
        if (!is_dir($target_dir)) mkdir($target_dir, 0777, true);
        $filename = uniqid('logo_') . '_' . basename($_FILES['site_logo_upload_new']['name']);
        $target_file = $target_dir . $filename;
        if (move_uploaded_file($_FILES['site_logo_upload_new']['tmp_name'], $target_file)) {
            $item['logo'] = 'uploads/' . $filename;
        }
    }
    if ($item['name'] && $item['url']) {
        $data['sites'][] = $item;
        file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        $flash = 'Yeni site eklendi.';
    }
}

// İletişim kartlarını kaydet
if (isset($_POST['contacts_save']) && isset($_POST['contact_name']) && is_array($_POST['contact_name'])) {
    $newContacts = [];
    foreach ($_POST['contact_name'] as $idx => $name) {
        if (trim($name) === '' && trim($_POST['contact_url'][$idx] ?? '') === '') continue;
        $c = [
            'name' => trim($name),
            'text' => trim($_POST['contact_text'][$idx] ?? ''),
            'url' => trim($_POST['contact_url'][$idx] ?? ''),
            'button_text' => trim($_POST['contact_button_text'][$idx] ?? 'GİT'),
            'logo' => trim($_POST['contact_logo_link'][$idx] ?? '')
        ];
        if (!empty($_FILES['contact_logo_upload']['name'][$idx])) {
            $target_dir = __DIR__ . '/uploads/';
            if (!is_dir($target_dir)) mkdir($target_dir, 0777, true);
            $filename = uniqid('logo_') . '_' . basename($_FILES['contact_logo_upload']['name'][$idx]);
            $target_file = $target_dir . $filename;
            if (move_uploaded_file($_FILES['contact_logo_upload']['tmp_name'][$idx], $target_file)) {
                $c['logo'] = 'uploads/' . $filename;
            }
        }
        $newContacts[] = $c;
    }
    $data['contacts'] = $newContacts;
    file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    $flash = 'İletişim kartları kaydedildi.';
}

// Yeni iletişim kartı ekle
if (isset($_POST['contact_add'])) {
    $c = [
        'name' => trim($_POST['contact_name_new'] ?? ''),
        'text' => trim($_POST['contact_text_new'] ?? ''),
        'url' => trim($_POST['contact_url_new'] ?? ''),
        'button_text' => trim($_POST['contact_button_text_new'] ?? 'GİT'),
        'logo' => trim($_POST['contact_logo_link_new'] ?? '')
    ];
    if (!empty($_FILES['contact_logo_upload_new']['name'])) {
        $target_dir = __DIR__ . '/uploads/';
        if (!is_dir($target_dir)) mkdir($target_dir, 0777, true);
        $filename = uniqid('logo_') . '_' . basename($_FILES['contact_logo_upload_new']['name']);
        $target_file = $target_dir . $filename;
        if (move_uploaded_file($_FILES['contact_logo_upload_new']['tmp_name'], $target_file)) {
            $c['logo'] = 'uploads/' . $filename;
        }
    }
    if ($c['name'] && $c['url']) {
        $data['contacts'][] = $c;
        file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        $flash = 'Yeni iletişim kartı eklendi.';
    }
}

// Stats
            $statsFile = __DIR__ . '/site_stats.json';
$stats = file_exists($statsFile) ? json_decode(file_get_contents($statsFile), true) : ['visits' => ['total' => 0, 'days' => [], 'weeks' => [], 'months' => []], 'urls' => []];
            $today = date('Y-m-d');
            $yesterday = date('Y-m-d', strtotime('-1 day'));
            $thisWeek = date('o-W');
            $thisMonth = date('Y-m');
            ?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Paneli</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { background:#0f172a; color:#e2e8f0; }
        .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); box-shadow: 0 12px 40px rgba(0,0,0,0.35); }
        input, textarea, select { background:#0b1220; border:1px solid #1f2937; border-radius:0.8rem; padding:0.75rem 0.9rem; width:100%; }
        input:focus, textarea:focus, select:focus { outline:none; border-color:#22d3ee; box-shadow:0 0 0 3px rgba(34,211,238,0.15); }
        label { color:#cbd5e1; font-weight:600; }
    </style>
</head>
<body class="pb-12">
    <div class="max-w-6xl mx-auto px-4 pt-6">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3 mb-6">
            <div>
                <p class="text-sm text-slate-400">Tüm site yönetimi</p>
                <h1 class="text-2xl font-extrabold text-white">Admin Paneli</h1>
            </div>
            <div class="flex items-center gap-2">
                <button type="button" id="showStatsBtn" class="px-4 py-2 rounded-xl bg-white/10 text-white border border-white/10 hover:bg-white/15"><i class="fa-solid fa-chart-line mr-2 text-cyan-300"></i>İstatistikler</button>
                <form method="post"><button type="submit" name="logout" class="px-4 py-2 rounded-xl bg-red-500/90 text-white font-semibold">Çıkış</button></form>
            </div>
        </div>

        <?php if ($flash): ?>
            <div class="mb-4 rounded-xl bg-emerald-500/10 text-emerald-200 border border-emerald-400/30 px-4 py-3 flex items-center gap-2">
                <i class="fa-solid fa-circle-check"></i> <?= htmlspecialchars($flash) ?>
            </div>
        <?php endif; ?>

        <!-- Genel toplu form -->
        <form method="post" class="glass rounded-2xl p-5 mb-6 space-y-4">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-bold text-white">Genel Ayarlar (Toplu Kaydet)</h2>
                <button type="submit" name="general_save" class="px-4 py-2 rounded-xl bg-gradient-to-r from-cyan-400 to-emerald-400 text-slate-900 font-bold shadow-lg">Kaydet</button>
            </div>
            <div class="grid md:grid-cols-2 gap-4">
                <div><label>Site Title</label><input type="text" name="meta_title" value="<?= htmlspecialchars($data['meta']['title']) ?>"></div>
                <div><label>Site Description</label><input type="text" name="meta_description" value="<?= htmlspecialchars($data['meta']['description']) ?>"></div>
            </div>
            <div class="grid md:grid-cols-4 gap-4">
                <div><label>Popup Başlık</label><input type="text" name="popup_title" value="<?= htmlspecialchars($data['popup']['title']) ?>"></div>
                <div><label>Popup Açıklama</label><input type="text" name="popup_desc" value="<?= htmlspecialchars($data['popup']['desc']) ?>"></div>
                <div><label>Popup Buton Metni</label><input type="text" name="popup_button_text" value="<?= htmlspecialchars($data['popup']['button_text']) ?>"></div>
                <div><label>Popup Link</label><input type="text" name="popup_button_link" value="<?= htmlspecialchars($data['popup']['button_link']) ?>"></div>
            </div>
            <div class="grid md:grid-cols-3 gap-4">
                <div><label>Üst Kayan Yazı</label><input type="text" name="ticker_top_text" value="<?= htmlspecialchars($data['ticker_top']['text'] ?? '') ?>"></div>
                <div><label>Üst Buton Metni</label><input type="text" name="ticker_top_button_text" value="<?= htmlspecialchars($data['ticker_top']['button_text'] ?? '') ?>"></div>
                <div><label>Üst Buton Linki</label><input type="text" name="ticker_top_button_link" value="<?= htmlspecialchars($data['ticker_top']['button_link'] ?? '') ?>"></div>
            </div>
            <div class="grid md:grid-cols-3 gap-4">
                <div><label>Alt Kayan Yazı</label><input type="text" name="ticker_bottom_text" value="<?= htmlspecialchars($data['ticker_bottom']['text'] ?? '') ?>"></div>
                <div><label>Alt Buton Metni</label><input type="text" name="ticker_bottom_button_text" value="<?= htmlspecialchars($data['ticker_bottom']['button_text'] ?? '') ?>"></div>
                <div><label>Alt Buton Linki</label><input type="text" name="ticker_bottom_button_link" value="<?= htmlspecialchars($data['ticker_bottom']['button_link'] ?? '') ?>"></div>
            </div>
            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label>Banner Başlıkları (her satıra bir)</label>
                    <textarea name="banner_titles" rows="4"><?= htmlspecialchars(implode("\n", $data['banner_titles'])) ?></textarea>
                </div>
                <div class="grid md:grid-cols-2 gap-3">
                    <div class="col-span-2 font-bold text-white">Üst Bannerlar</div>
                    <?php for ($i=0;$i<3;$i++): ?>
                        <div class="col-span-2 bg-white/5 p-3 rounded-xl">
                            <p class="text-sm text-slate-300 font-semibold mb-2">Banner <?= $i+1 ?></p>
                            <input type="text" name="top_banner_image[<?= $i ?>]" placeholder="Resim URL" value="<?= htmlspecialchars($data['top_banners'][$i]['image']) ?>">
                            <input type="text" name="top_banner_url[<?= $i ?>]" placeholder="Yönlendirilecek URL" value="<?= htmlspecialchars($data['top_banners'][$i]['url']) ?>">
                            <input type="text" name="top_banner_alt[<?= $i ?>]" placeholder="Alt metin" value="<?= htmlspecialchars($data['top_banners'][$i]['alt']) ?>">
                        </div>
                    <?php endfor; ?>
                    <div class="col-span-2 font-bold text-white mt-2">Alt Bannerlar</div>
                    <?php for ($i=0;$i<3;$i++): ?>
                        <div class="col-span-2 bg-white/5 p-3 rounded-xl">
                            <p class="text-sm text-slate-300 font-semibold mb-2">Banner <?= $i+1 ?></p>
                            <input type="text" name="bottom_banner_image[<?= $i ?>]" placeholder="Resim URL" value="<?= htmlspecialchars($data['bottom_banners'][$i]['image']) ?>">
                            <input type="text" name="bottom_banner_url[<?= $i ?>]" placeholder="Yönlendirilecek URL" value="<?= htmlspecialchars($data['bottom_banners'][$i]['url']) ?>">
                            <input type="text" name="bottom_banner_alt[<?= $i ?>]" placeholder="Alt metin" value="<?= htmlspecialchars($data['bottom_banners'][$i]['alt']) ?>">
                        </div>
                    <?php endfor; ?>
                    </div>
                    </div>
        </form>

        <!-- Birleşik içerik listesi -->
        <form method="post" enctype="multipart/form-data" class="glass rounded-2xl p-5 space-y-4">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-bold text-white">İçerikler (Site / İletişim)</h2>
                <button type="submit" name="combined_save" class="px-4 py-2 rounded-xl bg-gradient-to-r from-cyan-400 to-emerald-400 text-slate-900 font-bold shadow-lg">Kaydet</button>
                    </div>
            <div class="grid gap-4">
                <?php foreach ($combined as $i => $item): ?>
                    <div class="bg-white/5 p-4 rounded-xl border border-white/5 space-y-2">
                        <div class="flex items-center justify-between mb-2">
                            <div class="flex items-center gap-2">
                                <span class="px-2 py-1 rounded-full bg-white/10 text-xs">#<?= $i+1 ?></span>
                                <select name="item_type[<?= $i ?>]" class="bg-slate-800 border border-slate-700 rounded px-2 py-1 text-xs text-white">
                                    <option value="site" <?= $item['type']==='site'?'selected':''; ?>>Site</option>
                                    <option value="contact" <?= $item['type']==='contact'?'selected':''; ?>>İletişim</option>
                                </select>
                                <span class="font-semibold text-white"><?= htmlspecialchars($item['name']) ?></span>
                    </div>
                            <div class="flex items-center gap-2">
                                <button type="submit" name="move_up_combined" value="<?= $i ?>" class="px-2 py-1 rounded-lg bg-white/10 text-white text-xs" <?= $i==0?'disabled':''; ?>>▲</button>
                                <button type="submit" name="move_down_combined" value="<?= $i ?>" class="px-2 py-1 rounded-lg bg-white/10 text-white text-xs" <?= $i==count($combined)-1?'disabled':''; ?>>▼</button>
                    </div>
                        </div>
                        <div class="grid md:grid-cols-3 gap-3">
                            <div><label>Ad</label><input type="text" name="item_name[<?= $i ?>]" value="<?= htmlspecialchars($item['name']) ?>"></div>
                            <div><label>Metin / Bonus</label><input type="text" name="item_text[<?= $i ?>]" value="<?= htmlspecialchars($item['bonus'] ?? $item['text'] ?? '') ?>"></div>
                            <div><label>Buton Metni</label><input type="text" name="item_button_text[<?= $i ?>]" value="<?= htmlspecialchars($item['button_text'] ?? 'GİRİŞ YAP') ?>"></div>
                            <div><label>URL</label><input type="text" name="item_url[<?= $i ?>]" value="<?= htmlspecialchars($item['url']) ?>"></div>
                            <div>
                                <label>Yıldız (site)</label>
                                <select name="item_stars[<?= $i ?>]">
                                    <option value="4" <?= ($item['stars'] ?? 4)==4?'selected':''; ?>>4</option>
                                    <option value="4.5" <?= ($item['stars'] ?? 4)==4.5?'selected':''; ?>>4.5</option>
                                    <option value="5" <?= ($item['stars'] ?? 4)==5?'selected':''; ?>>5</option>
                                </select>
                </div>
                <div>
                                <label>Logo Linki</label>
                                <input type="text" name="item_logo_link[<?= $i ?>]" value="<?= htmlspecialchars($item['logo'] ?? '') ?>">
                                <input type="file" name="item_logo_upload[<?= $i ?>]" class="mt-2 text-sm text-slate-300">
                            </div>
                        </div>
                        <div class="grid md:grid-cols-2 gap-3">
                            <label class="flex items-center gap-2 text-sm text-slate-200">
                                <input type="checkbox" name="item_badge_show[<?= $i ?>]" <?= isset($item['licensed_badge']['show']) && $item['licensed_badge']['show'] ? 'checked' : '' ?> class="w-4 h-4">
                                Badge (site)
                            </label>
                            <input type="text" name="item_badge_text[<?= $i ?>]" placeholder="Badge Metni" value="<?= htmlspecialchars($item['licensed_badge']['text'] ?? 'LİSANSLI') ?>">
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </form>

        <!-- Yeni içerik ekle -->
        <div class="glass rounded-2xl p-5 mt-6 space-y-3">
            <h3 class="text-lg font-bold text-white">Yeni İçerik Ekle</h3>
            <form method="post" enctype="multipart/form-data" class="grid md:grid-cols-3 gap-3">
                <select name="item_type_new">
                    <option value="site">Site</option>
                    <option value="contact">İletişim</option>
                </select>
                <input required type="text" name="item_name_new" placeholder="Ad">
                <input required type="text" name="item_url_new" placeholder="https://">
                <input type="text" name="item_text_new" placeholder="Metin / Bonus">
                <input type="text" name="item_button_text_new" placeholder="Buton Metni">
                <select name="item_stars_new">
                    <option value="4">4</option>
                    <option value="4.5">4.5</option>
                    <option value="5">5</option>
                </select>
                <input type="text" name="item_logo_link_new" placeholder="Logo Linki (opsiyonel)">
                <input type="file" name="item_logo_upload_new" accept="image/*" class="md:col-span-2">
                <label class="flex items-center gap-2 text-sm text-slate-200 md:col-span-1">
                    <input type="checkbox" name="item_badge_show_new" class="w-4 h-4"> Badge Göster (site)
                </label>
                <input type="text" name="item_badge_text_new" placeholder="Badge Metni (varsayılan: LİSANSLI)" class="md:col-span-2">
                <button type="submit" name="item_add" class="md:col-span-3 px-4 py-3 rounded-xl bg-gradient-to-r from-cyan-400 to-emerald-400 text-slate-900 font-bold">Ekle</button>
            </form>
        </div>

    <!-- İstatistik modal -->
    <div id="statsModal" class="hidden fixed inset-0 z-50 bg-black grid place-items-center px-4">
        <div class="bg-slate-900 rounded-2xl p-6 max-w-2xl w-full border border-white/10 relative shadow-2xl">
            <button onclick="document.getElementById('statsModal').classList.add('hidden')" class="absolute top-3 right-3 text-slate-300 hover:text-white">
                <i class="fa-solid fa-xmark text-xl"></i>
            </button>
            <h3 class="text-xl font-bold text-white mb-3">Site İstatistikleri</h3>
            <div class="grid md:grid-cols-2 gap-4">
                <div class="space-y-2">
                    <div class="flex justify-between text-slate-300"><span>Bugün</span><span class="font-bold text-cyan-300"><?= $stats['visits']['days'][$today] ?? 0 ?></span></div>
                    <div class="flex justify-between text-slate-300"><span>Dün</span><span class="font-bold text-cyan-300"><?= $stats['visits']['days'][$yesterday] ?? 0 ?></span></div>
                    <div class="flex justify-between text-slate-300"><span>Bu Hafta</span><span class="font-bold text-cyan-300"><?= $stats['visits']['weeks'][$thisWeek] ?? 0 ?></span></div>
                    <div class="flex justify-between text-slate-300"><span>Bu Ay</span><span class="font-bold text-cyan-300"><?= $stats['visits']['months'][$thisMonth] ?? 0 ?></span></div>
                    <div class="flex justify-between text-slate-300"><span>Toplam</span><span class="font-bold text-cyan-300"><?= $stats['visits']['total'] ?? 0 ?></span></div>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-[520px] w-full text-sm bg-white/5 rounded-xl border border-white/10">
                        <thead class="bg-white/10 text-slate-200">
                        <tr>
                            <th class="py-2 px-2 text-left">Link</th>
                            <th class="py-2 px-2">Bugün</th>
                            <th class="py-2 px-2">Dün</th>
                            <th class="py-2 px-2">Hafta</th>
                            <th class="py-2 px-2">Ay</th>
                            <th class="py-2 px-2">Toplam</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $siteNames = [];
                                if (file_exists($dataFile)) {
                                    $dataJson = json_decode(file_get_contents($dataFile), true);
                                    if (isset($dataJson['sites'])) {
                                        foreach ($dataJson['sites'] as $site) {
                                            if (!empty($site['url']) && !empty($site['name'])) {
                                                $siteNames[$site['url']] = $site['name'];
                                            }
                                        }
                                    }
                            $popupLink = $dataJson['popup']['button_link'] ?? '';
                        } else { $popupLink = ''; }
                                $rows = [];
                        if (isset($stats['urls']['POPUP'])) $rows[] = ['type'=>'popup','name'=>'POPUP','data'=>$stats['urls']['POPUP']];
                        foreach ($stats['urls'] as $url => $dataRow) {
                            if ($url === 'POPUP') continue;
                                    $isSite = isset($siteNames[$url]);
                            $rows[] = ['type'=>$isSite?'site':'url','name'=>$isSite?$siteNames[$url]:$url,'data'=>$dataRow];
                                    }
                        foreach ($rows as $row): ?>
                            <tr class="border-b border-white/5">
                                <td class="py-2 px-2 text-slate-200">
                                            <?php if ($row['type'] === 'popup'): ?>
                                        <span class="text-amber-300 font-semibold">POPUP</span>
                                            <?php elseif ($row['type'] === 'site'): ?>
                                        <span class="text-cyan-300 font-semibold"><?= htmlspecialchars($row['name']) ?></span>
                                            <?php else: ?>
                                        <a href="<?= htmlspecialchars($row['name']) ?>" class="underline text-white" target="_blank"><?= htmlspecialchars($row['name']) ?></a>
                                            <?php endif; ?>
                                        </td>
                                <td class="py-2 px-2 text-center text-cyan-200"><?= $row['data']['days'][$today] ?? 0 ?></td>
                                <td class="py-2 px-2 text-center text-cyan-200"><?= $row['data']['days'][$yesterday] ?? 0 ?></td>
                                <td class="py-2 px-2 text-center text-cyan-200"><?= $row['data']['weeks'][$thisWeek] ?? 0 ?></td>
                                <td class="py-2 px-2 text-center text-cyan-200"><?= $row['data']['months'][$thisMonth] ?? 0 ?></td>
                                <td class="py-2 px-2 text-center text-emerald-300 font-bold"><?= $row['data']['total'] ?? 0 ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    <script>
        document.getElementById('showStatsBtn').onclick = () => document.getElementById('statsModal').classList.remove('hidden');
    </script>
</body>
</html>

